**************************************************************************************************************************************************
******************* Code for 'Are Investment Tax Breaks Effective: Australian Evidence' *******************
***************************************************** Code for DD regressions ******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
*********************************************************************************************************************************************
*** Code strcuture
*00. Preliminaries and globals
*01. Load data
*02 MAke variable
*03 Regressions and charting for each policy

************* 00. Preliminaries **********					  

clear all
global data ""
global savefile ""
sysdir set PLUS ""
sysdir set PERSONAL ""
mata: mata mlib index

************* 01. Laod and clean data **********					  

use "$data\capex_bit_frame_eginc_COY_20.dta", clear

*************************************************
*Additional data construction
*************************************************
recode quarter (1=3 "Sep") (2=4 "Dec") (3=1 "Mar") (4=2 "June"), gen(CalQuarter)
gen time = yq(year, quarter)-2
format time %tq
drop if time==.

gen company = (bit_comp_ ==1 )	
gen individual = (bit_ind_ ==1 )	
gen partnership= (bit_part_ ==1 )	
gen trust= (bit_trust_ ==1 )

gen NotCompany = (bit_comp_ !=1 )	
gen NotCompanyNorTrust = (bit_comp_ !=1 & bit_trust_ !=1)	

sum firmid if company!=1 & individual!=1 & partnership!=1 & trust!=1
sum firmid if company==1 | individual==1 | partnership==1 | trust==1

encode division, g(div)
************* 02. MAke key varaibles **********					  

*log LHS variables
g l_caeqtot=ln(caeqtot)

*dummies for non-zero investment and expectations firms
g inv = 1 if (caeqtot_capex>0 & caeqtot_capex!=.)
g exp_1 = 1 if (ce1eqtot_capex>0 & ce1eqtot_capex!=.)
g exp_2 = 1 if (ce2eqtot_capex>0 & ce2eqtot_capex!=.)

*RHS variables
gen l_income= log(income)
gen l_income_l = ln(income_l)
gen l_income_l2 = ln(income_l2)

replace income_eg=income if income_eg==.
replace income_l_eg=income_l if income_l_eg==.
replace income_l2_eg=income_l2 if income_l2_eg==.

gen l_income_eg= log(income_eg)
gen l_income_l_eg = ln(income_l_eg)
gen l_income_l2_eg = ln(income_l2_eg)


xtile pct_income = l_income, nquantiles(10)
xtile pct_foreign = c_for_share_lag, nquantiles(10)


xtset firmid date

gen fte_l_firm = L.fte
gen l_fte_l = ln(fte_l)  
xtile pct_income_l = l_income_l, nquantiles(10) 


************* 03. REgressions **********					  

*2008 policy
**********************

* 1. Create policy treatment groups
**********************************************
capture log using 2008 Policy, replace 

gen policy_group_2008 = .
replace  policy_group_2008 = 1 if (income_l_eg < 2 000 000)
replace  policy_group_2008 = 0 if (income_l_eg > 2 000 000 & income_l_eg < 5 000 000)

g pol_period_2008 =  0
replace pol_period = 1 if (quarter == 1 & year == 2010) | (quarter == 2 & year == 2010)

* 2. Create Log Odds
**************************
bysort policy_group_2008 industry date: egen firms_size_ind = total(caeqtot_capex!=.)
bysort policy_group_2008 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2008 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2008 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1

*3. Estimate
*****************************
foreach TO in policy_group_2008 {
foreach var in l_caeqtot log_odds {
	
	if "`var'" ==  "l_caeqtot" {
		local cluster firmid
		local control l_fte_l i.pct_income
	}

		if "`var'" ==  "log_odds"  {
		local cluster industry
		local control  
	}
	
	
*All entities, companies, unincorps, no mining, with controls
eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008  `control' if date>= 42 & date< 61 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008  `control' if date>= 42 & date< 61 & division!="B"  & company ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008  `control' if date>= 42 & date< 61 & division!="B"  & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

*All entities, companies, unincorps no mining 
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008 if date>= 42 & date< 61 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008 if date>= 42 & date< 61 & division!="B"  & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008 if date>= 42 & date< 61 & division!="B"   & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2009_`var'_indicator.rtf", se keep(*policy_group_2008*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")
}
}

capture log close 

*4. Charting
********************

** Remove size and seaonal patterns from investment
capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.policy_group_2008 if date>= 42 & date< 59 
predict resid_`var', residuals
}
** And plot regisual by group 
foreach TO in policy_group_2008 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'.xlsx, replace firstrow(variables)
}
restore

** Version also removing  industry
capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.policy_group_2008 i.div##i.date if date>= 42 & date< 59 
predict resid_`var', residuals
}

foreach TO in policy_group_2008 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'div.xlsx, replace firstrow(variables)
}
restore

***************************************************************************
*2012 policy
****************************************************************************

* 1. Create policy treatment group
************************************
capture log using 2012_actuals, replace 

g policy_group_2012 = .
replace  policy_group_2012 = 1 if (income_l_eg < 2000000 ) 
replace  policy_group_2012= 0 if (income_l_eg > 2000000 & income_l_eg < 5000000) 

g pol_period_2012 =  0

replace pol_period_2012 = 1 if ((quarter == 1 & year == 2013) | (quarter == 2 & year == 2013)| (quarter ==3 & year == 2013)| (quarter == 4 & year == 2013) | (quarter == 1 & year == 2014) | (quarter ==2 & year == 2014))


* 2. Create Log Odds
**************************
capture drop firms_size_ind invs_size_ind exp1_size_ind exp2_size_ind invs_size_ind_share exp1_size_ind_share exp2_size_ind_share log_odds log_odds_exp1 log_odds_exp2

bysort policy_group_2012 industry date: egen firms_size_ind = total(caeqtot_capex!=.)
bysort policy_group_2012 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2012 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2012 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1


foreach TO in policy_group_2012 {

foreach var in l_caeqtot log_odds {
	
	if "`var'" ==  "l_caeqtot" {
		local cluster firmid
		local control l_fte_l i.pct_income 
	}
	
	if "`var'" ==  "log_odds"  {
		local cluster industry
		local control 
	}
eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2012 `control' if  date >=52 & date <=72 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2012 `control' if  date >=52 & date <=72 & division!="B" & company ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2012 `control' if  date >=52 & date <=72 & division!="B" & NotCompany==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

eststo: reghdfe `var'  i.`TO'##i.pol_period_2012  if date >=52 & date <=72 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2012  if date >=52 & date <=72 & division!="B" & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2012  if date >=52 & date <=72 & division!="B" & NotCompanyNorTrust ==1  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2012_`var'.rtf", se keep(*policy*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")
}
}

capture log close


*4. Charting
********************

capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.policy_group_2012 if date>= 52 & date< 72 
predict resid_`var', residuals
}

foreach TO in policy_group_2012 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'.xlsx, replace firstrow(variables)
}
restore


capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.policy_group_2012 i.div##i.date if date>= 52 & date< 72
predict resid_`var', residuals
}

foreach TO in policy_group_2012 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'div.xlsx, replace firstrow(variables)
}
restore



****************************************************************************
*2015 policy
****************************************************************************

* 1. Create policy treatment group
************************************

capture log using 2015_actuals, replace 

gen policy_group_2015 = .
replace policy_group_2015 = 1 if (income_l_eg < 2 000 000)
replace policy_group_2015 = 0 if (income_l_eg > 2 000 000 & income_l_eg < 5 000 000)

g pol_period_2015 =  0

replace pol_period_2015 = ((quarter == 4 & year == 2015) | (quarter == 1 & year == 2016) | (quarter ==2 & year == 2016) )

*2. Create Log Odds
**************************
capture drop firms_size_ind invs_size_ind exp1_size_ind exp2_size_ind invs_size_ind_share exp1_size_ind_share exp2_size_ind_share log_odds log_odds_exp1 log_odds_exp2

bysort policy_group_2015 industry date: egen firms_size_ind = total(caeqtot_capex!=.)
bysort policy_group_2015 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2015 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2015 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1

*Estimate
*****************************

foreach TO in  policy_group_2015 {  

foreach var in l_caeqtot log_odds {
	
	if "`var'" ==  "l_caeqtot" {
		local cluster firmid
		local control l_fte_l i.pct_income 
	}
	
	if "`var'" ==  "log_odds"  {
		local cluster industry
		local control 
	}
eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 `control' if date >=68 & date <=77 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 `control' if date >=68 & date <=77 & division!="B" & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 `control' if date >=68 & date <=77 & division!="B" & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')



eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 if date >=68 & date <=77 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 if date >=68 & date <=77 & division!="B" & company ==1  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 if date >=68 & date <=77 & division!="B" & NotCompanyNorTrust ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2015_`var'.rtf", se keep(*policy*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")
}
}

capture log close


*4. Charting
********************

capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2015 if date>= 68 & date< 77 
predict resid_`var', residuals
}

foreach TO in pol_period_2015 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'.xlsx, replace firstrow(variables)
}
restore


capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2015 i.div##i.date if date>= 68 & date< 77
predict resid_`var', residuals
}

foreach TO in pol_period_2015 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'div.xlsx, replace firstrow(variables)
}
restore


************************************************************
*2016 policy
************************************************************
* 1. Create policy treatment group
************************************
capture log using 2016_actuals, replace 

gen policy_group_2016 = .
replace policy_group_2016 = 1 if  (income_l_eg > 2 000 000 & income_l_eg < 10 000 000)
replace policy_group_2016 = 0 if (income_l_eg > 10 000 000 & income_l_eg < 20 000 000)


g pol_period_2016 =  0
replace pol_period_2016 = ((quarter == 1 & year == 2017) | (quarter == 2 & year == 2017)| (quarter == 3 & year == 2017)| (quarter == 4 & year == 2017))


*Create Log Odds
**************************
capture drop firms_size_ind invs_size_ind exp1_size_ind exp2_size_ind invs_size_ind_share exp1_size_ind_share exp2_size_ind_share log_odds log_odds_exp1 log_odds_exp2

bysort policy_group_2016 industry date: egen firms_size_ind = total(caeqtot_capex!=.)
bysort policy_group_2016 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2016 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2016 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1


*Estimate
*****************************
foreach TO in policy_group_2016 { 
*caeqtot_nz
foreach var in l_caeqtot log_odds  {
	
	if "`var'" ==  "l_caeqtot" {
		local cluster firmid
		local control l_fte_l i.pct_income 
	}
	
	if "`var'" ==  "log_odds"  {
		local cluster industry
		local control 
	}
	
eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016  `control' if date >=70 & date <=88 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016  `control' if date >=70 & date <=88 & division!="B" & company ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016  `control' if date >=70 & date <=88 & division!="B"  & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

eststo: reghdfe `var'  i.`TO'##i.pol_period_2016   if date >=70 & date <=88 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016   if date >=70 & date <=88 & division!="B" & company ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016   if date >=70 & date <=88 & division!="B"  & NotCompany ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2016_`var'.rtf", se keep(*pol*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")
}
}

capture log close


*4. Charting
********************

capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2016 if date>= 70 & date< 88 
predict resid_`var', residuals
}

foreach TO in pol_period_2016 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'.xlsx, replace firstrow(variables)
}
restore


capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2016 i.div##i.date if date>= 70 & date< 88
predict resid_`var', residuals
}

foreach TO in pol_period_2016 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'div.xlsx, replace firstrow(variables)
}
restore



**************************************************************************************************************************************************
*2019 policy
**************************************************************************************************************************************************
* 1. Create policy treatment group
************************************

capture log using 2019_actuals, replace 

gen policy_group_2019 = .
replace policy_group_2019 = 1 if  (income_l_eg > 10 000 000 & income_l_eg < 50 000 000)
replace policy_group_2019 = 0 if (income_l_eg > 50 000 000 & income_l_eg < 60 000 000)

g pol_period_2019 =  0
replace pol_period_2019 = ((quarter == 4 & year == 2019) | (quarter == 1 & year == 2020) | (quarter == 2 & year == 2020) | (quarter == 3 & year == 2020))


*2. Create Log Odds
**************************
drop firms_size_ind invs_size_ind exp1_size_ind exp2_size_ind invs_size_ind_share exp1_size_ind_share exp2_size_ind_share log_odds log_odds_exp1 log_odds_exp2

bysort policy_group_2019 industry date: egen firms_size_ind = total(caeqtot_capex!=.)
bysort policy_group_2019 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2019 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2019 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1


*Estimate
*****************************
foreach TO in policy_group_2019  {

foreach var in l_caeqtot log_odds{
	
	if "`var'" ==  "l_caeqtot" {
		local cluster firmid
		local control l_fte_l i.pct_income 
	}

	
	if "`var'" ==  "log_odds"  {
		local cluster industry
		local control 
	}
	
*margins `TO', dydx(date)
eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2019  `control' if date >=80 & date <=92 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2019  `control' if date >=80 & date <=92 & division!="B" & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2019  `control' if date >=80 & date <=92 & division!="B" & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

eststo: reghdfe `var'  i.`TO'##i.pol_period_2019  if date >=80 & date <=92 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2019  if date >=80 & date <=92 & division!="B" & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2019  if date >=80 & date <=92 & division!="B" & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')


esttab using "2019_`var'.rtf", se keep(*pol*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls" )
}
}

capture log close


*4. Charting
********************

capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2019 if date>= 80 & date< 92 
predict resid_`var', residuals
}

foreach TO in pol_period_2019 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'.xlsx, replace firstrow(variables)
}
restore


capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2019 i.div##i.date if date>= 80 & date< 92
predict resid_`var', residuals
}

foreach TO in pol_period_2019 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'div.xlsx, replace firstrow(variables)
}
restore



**************************************************************************************************************************************************
*2020 policy
**********************************************************************************************************************************************


capture log using 2020_actuals, replace 

gen policy_group_2020 = .
replace policy_group_2020 = 1 if  (income_l_eg > 50 000 000 & income_l_eg < 500 000 000)
replace policy_group_2020 = 0 if (income_l_eg > 500 000 000 & income_l_eg < 600 000 000)

g pol_period_2020 =  0
replace pol_period_2020 = ((quarter == 3 & year == 2020)| (quarter == 4 & year == 2020) | (quarter == 1 & year == 2020))

*Create Log Odds
**************************
capture drop firms_size_ind invs_size_ind exp1_size_ind exp2_size_ind invs_size_ind_share exp1_size_ind_share exp2_size_ind_share log_odds log_odds_exp1 log_odds_exp2

bysort policy_group_2020 industry date: egen firms_size_ind = total(caeqtot_capex!=.)
bysort policy_group_2020 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2020 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2020 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1

*Estimate
*****************************

foreach TO in policy_group_2020  {

foreach var in l_caeqtot log_odds  {
	
	if "`var'" ==  "l_caeqtot" {
		local cluster firmid
		local control l_fte_l i.pct_income 
	}
	
	if "`var'" ==  "log_odds"  {
		local cluster industry
		local control 
	}

*margins `TO', dydx(date)
eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2020  `control' if date >=80 & date <=94 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2020  `control' if date >=80 & date <=94 & division!="B" & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2020  `control' if date >=80 & date <=94 & division!="B" & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

eststo: reghdfe `var'  i.`TO'##i.pol_period_2020  if date >=80 & date <=94 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2020  if date >=80 & date <=94 & division!="B" & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2020  if date >=80 & date <=94 & division!="B" & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2020_`var'.rtf", se keep(*pol*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")
}
}

capture log close



*4. Charting
********************

capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2020 if date>= 80 & date< 94 
predict resid_`var', residuals
}

foreach TO in pol_period_2020 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'.xlsx, replace firstrow(variables)
}
restore


capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2020 i.div##i.date if date>= 80 & date< 94
predict resid_`var', residuals
}

foreach TO in pol_period_2020 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'div.xlsx, replace firstrow(variables)
}
restore



*************************************************
*2021 policy
*************************************************
* 1. Create policy and control groups
*****************************************


capture log using 2021_actuals, replace 

gen policy_group_2021 = .
replace policy_group_2021 = 1 if  (income_l_eg > 500 000 000 & income_l_eg < 5 000 000 000)
replace policy_group_2021 = 0 if (income_l_eg > 5 000 000 000 & income_l_eg < 6 000 000 000)


g pol_period_2021 =  0
replace pol_period_2021 = ((quarter == 2 & year == 2021)| (quarter ==3 & year == 2021)| (quarter == 4 & year == 2021))


*Create Log Odds
**************************
capture drop firms_size_ind invs_size_ind exp1_size_ind exp2_size_ind invs_size_ind_share exp1_size_ind_share exp2_size_ind_share log_odds log_odds_exp1 log_odds_exp2

bysort policy_group_2021 industry date: egen firms_size_ind = total(caeqtot_capex!=.)
bysort policy_group_2021 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2021 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2021 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1

*Estimate
*****************************
foreach TO in policy_group_2021  {

foreach var in l_caeqtot log_odds {
	
	if "`var'" ==  "l_caeqtot" {
		local cluster firmid
		local control  l_fte_l i.pct_income 
	}
	
	if "`var'" ==  "log_odds"  {
		local cluster industry
		local control 
	}

*margins `TO', dydx(date)

eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2021  `control' if date >=90 & date <=99 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2021  `control' if date >=90 & date <=99 & division!="B"  & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2021  `control' if date >=90 & date <=99 & division!="B" & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')


eststo: reghdfe `var'  i.`TO'##i.pol_period_2021  if date >=90 & date <=99 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2021  if date >=90 & date <=99 & division!="B" & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2021  if date >=90 & date <=99 & division!="B" & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2021_`var'.rtf", se keep(*pol*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")

}
}

capture log close



*4. Charting
********************

capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2021 if date>= 90 & date< 99 
predict resid_`var', residuals
}

foreach TO in pol_period_2021 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'.xlsx, replace firstrow(variables)
}
restore


capture drop resid_*  
preserve
drop if division =="B"
foreach var in l_caeqtot log_odds {
reg `var' l_fte_l  i.pct_income i.quarter#i.pol_period_2021 i.div##i.date if date>= 90 & date< 99
predict resid_`var', residuals
}

foreach TO in pol_period_2021 {
drop if `TO' == .
collapse(mean)  resid_* quarter time (count) firmid, by(date `TO') 
 reshape wide resid_* firmid time, i(date quarter) j(`TO') 
drop time1
order _all, alpha
order time0, first
export excel using `TO'div.xlsx, replace firstrow(variables)
}
restore

